<?php
/*--------------------------------------------------------------
   Schema.php 2021-06-16
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2021 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Admin\Modules\Statistics\App\Overview\Model\ValueObjects;

use Swaggest\JsonSchema\Context as JsonSchemaContext;
use Swaggest\JsonSchema\Schema as JsonSchema;
use Swaggest\JsonSchema\SchemaContract as JsonSchemaContract;
use Webmozart\Assert\Assert;

class Schema
{
    /**
     * @var JsonSchemaContract
     */
    private $schema;
    
    /**
     * @var string
     */
    private $id;
    
    
    /**
     * Constructor.
     */
    private function __construct(string $id, string $path, JsonSchemaContext $context = null)
    {
        Assert::stringNotEmpty($id);
        Assert::fileExists($path);
        
        $this->id     = $id;
        $this->schema = JsonSchema::import(json_decode(file_get_contents($path)), $context);
    }
    
    
    /**
     * Create instance.
     */
    public static function create(string $id, string $path, JsonSchemaContext $context = null): self
    {
        return new self($id, $path, $context);
    }
    
    
    /**
     * Return name.
     */
    public function id(): string
    {
        return $this->id;
    }
    
    
    /**
     * Validate data.
     */
    public function validate($data): void
    {
        $this->schema->in($data);
    }
}